#include <bits/stdc++.h>
using namespace std;
typedef long long ll;

struct Point {
    ll x, y;
    Point(ll x = 0, ll y = 0) : x(x), y(y) {}
    
    bool operator < (const Point &p) const {
        if (x != p.x) return x < p.x;
        return y < p.y;
    }
    
    bool operator == (const Point &p) const {
        return x == p.x && y == p.y;
    }
};

// Vraca 2 puta površinu trougla
ll area2(const Point& a, const Point& b, const Point& c) {
    return abs((b.x - a.x) * (c.y - a.y) - (b.y - a.y) * (c.x - a.x));
}

// Proverava orijentaciju tri tacke
ll orientation(const Point& a, const Point& b, const Point& c) {
    return (b.x - a.x) * (c.y - a.y) - (b.y - a.y) * (c.x - a.x);
}

vector<Point> getConvexHull(vector<Point>& points) {
    int n = points.size();
    if (n <= 3) return points;
    
    // Nadi najnižu tacku (ako ih je više, uzmi najlevlju)
    int bottom = 0;
    for (int i = 1; i < n; i++) {
        if (points[i].y < points[bottom].y || 
            (points[i].y == points[bottom].y && points[i].x < points[bottom].x))
            bottom = i;
    }
    swap(points[0], points[bottom]);
    
    // Sortiraj ostale tacke po polarnom uglu
    Point p0 = points[0];
    sort(points.begin() + 1, points.end(), [&p0](const Point& p1, const Point& p2) {
        ll o = orientation(p0, p1, p2);
        if (o == 0) {
            ll d1 = (p1.x - p0.x) * (p1.x - p0.x) + (p1.y - p0.y) * (p1.y - p0.y);
            ll d2 = (p2.x - p0.x) * (p2.x - p0.x) + (p2.y - p0.y) * (p2.y - p0.y);
            return d1 < d2;
        }
        return o > 0;
    });
    
    vector<Point> hull;
    hull.push_back(points[0]);
    hull.push_back(points[1]);
    
    for (int i = 2; i < n; i++) {
        while (hull.size() >= 2 && orientation(hull[hull.size()-2], hull.back(), points[i]) <= 0)
            hull.pop_back();
        hull.push_back(points[i]);
    }
    
    return hull;
}

ll getArea(const vector<Point>& hull) {
    ll area = 0;
    int n = hull.size();
    for (int i = 0; i < n; i++) {
        int j = (i + 1) % n;
        area += hull[i].x * hull[j].y;
        area -= hull[j].x * hull[i].y;
    }
    return abs(area) / 2;
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    
    int n;
    cin >> n;
    
    vector<Point> points(n);
    for (int i = 0; i < n; i++) {
        cin >> points[i].x >> points[i].y;
    }
    
    ll minArea = LLONG_MAX;
    
    // Probamo da izbacimo svaku tacku
    for (int skip = 0; skip < n; skip++) {
        vector<Point> subset;
        for (int i = 0; i < n; i++) {
            if (i != skip) {
                subset.push_back(points[i]);
            }
        }
        
        vector<Point> hull = getConvexHull(subset);
        ll area = getArea(hull);
        minArea = min(minArea, area);
    }
    cout << minArea << "\n";
    return 0;
}